---
title: Polyglot Files
description: Collection of some ideas on polyglot file formats, with lots of useful links and pointers
keywords: Polyglot Files, Polyglot File Formats, This PDF is a ZIP, Executable file with embedded storage, Executable file with embedded file system
uuid: 13da8dde-4bd2-489a-a92b-fb431a778d68
publish: true
date: 2022-07-29
tags:
  - #kind/note
  - #topic/formats
  - #topic/polyglots
---

I realized that it was possible to create polyglot files[^polyglot] when I searched for the details of [the structure of a zip file](https://users.cs.jmu.edu/buchhofp/forensics/formats/pkzip-printable.html) [(Archived)](https://web.archive.org/web/20220526/https://users.cs.jmu.edu/buchhofp/forensics/formats/pkzip-printable.html) and found that the file header in this case is at the end of the file, and thus can easily coexist within an executable file, whose headers are usually at the start.

[^polyglot]: Files that are valid in more than one format. For example, a file may be [both a valid ZIP and a valid PDF](https://raw.githubusercontent.com/angea/pocorgtfo/master/contents/articles/01-05.pdf) [(Archived)](https://web.archive.org/web/20220528/https://raw.githubusercontent.com/angea/pocorgtfo/master/contents/articles/01-05.pdf).

<!-- More -->

I later found out the existence of [PoC||GTFO](https://github.com/angea/pocorgtfo) [(Archived)](https://web.archive.org/web/20220528/https://github.com/angea/pocorgtfo) and all other variously realized polyglot files, which usually are much more involved than simply having one header at the start and another one at the end, and many of which also have a sort of recursive madness (like [a PDF which is a Git repository containing its own LaTeX source and a copy of itself](https://raw.githubusercontent.com/angea/pocorgtfo/master/contents/articles/15-07.pdf) [(Archived)](https://web.archive.org/web/20220528/https://raw.githubusercontent.com/angea/pocorgtfo/master/contents/articles/15-07.pdf)).

Another incredible polyglot project is [Actually Portable Executable](https://justine.lol/ape.html) [(Archived)](https://web.archive.org/web/20220526/https://justine.lol/ape.html), a magic where a file is built which is a valid executable under Windows, Linux and MacOS (and BIOS), even though only for a single architecture (at least for now).

So an idea that I have seen arising multiple times is that of combining the two and create an executable program for all major platforms which also has a zip file-structure at the end, and that modifies the zip as if it were a filesystem to provide a persistence layer inside of a single file.

In this way one would realize the utopia of a single self-contained file that can be seamlessly moved from one computer to another one preserving both the fact that it is executable and its own data, which would actually be awesome.

As a bonus one can actually include a PDF into such mix which could store the documentation for the usage of the program. But maybe I'm getting too far...

If I picked your interest in this file madness I can recommend you those interesting references:
- [Funky File Formats (Slides)](https://fahrplan.events.ccc.de/congress/2014/Fahrplan/system/attachments/2562/original/Funky_File_Formats.pdf) [(Archived)](https://web.archive.org/web/20220528/https://fahrplan.events.ccc.de/congress/2014/Fahrplan/system/attachments/2562/original/Funky_File_Formats.pdf)
- [ZIP 101](https://raw.githubusercontent.com/corkami/pics/master/binary/zip101/zip101.pdf) [(Archived)](https://web.archive.org/web/20220528/https://raw.githubusercontent.com/corkami/pics/master/binary/zip101/zip101.pdf) and [PDF 101](https://raw.githubusercontent.com/corkami/pics/master/binary/pdf101/pdf101.pdf) [(Archived)](https://web.archive.org/web/20220528/https://raw.githubusercontent.com/corkami/pics/master/binary/pdf101/pdf101.pdf)
- [Abusing FIle Formats README](https://github.com/corkami/docs/blob/master/AbusingFileFormats/README.md) [(Archived)](https://web.archive.org/web/20220528/https://github.com/corkami/docs/blob/master/AbusingFileFormats/README.md)
